% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{add_star_column}
\alias{add_star_column}
\title{Adds stars next to a column based on p-values}
\usage{
add_star_column(
  data,
  ...,
  p = "p",
  merge = FALSE,
  superscript = TRUE,
  star = "\\\\*",
  alpha = c(0.05, 0.01, 0.001),
  first_alpha_marginal = FALSE,
  add_trailing_space = FALSE,
  prefix = "\\\\"
)
}
\arguments{
\item{data}{data.frame or tibble}

\item{...}{Column name or tidyselect function. Select columns}

\item{p}{Column name or tidyselect function. Select p-value column name}

\item{merge}{merge and balance columns (default: \code{FALSE})}

\item{superscript}{make as superscript}

\item{star}{text for making stars}

\item{alpha}{vector of thresholds}

\item{first_alpha_marginal}{if TRUE, the first alpha value is treated as marginal and gets a dagger instead of a star}

\item{add_trailing_space}{if TRUE, adds a trailing space after the stars (default: FALSE)}

\item{prefix}{usually backslashes to prevent markdown from interpreting asterisks as bullets or italics}
}
\value{
data.frame
}
\description{
Adds stars next to a column based on p-values
}
\examples{
data.frame(b = c(1.4,2.2),
           p = c(.54, .02)) |>
 add_star_column(b, p)
}
