% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim-prep-cat.R
\name{anim_prep_cat}
\alias{anim_prep_cat}
\title{Transformed category data into a categorized format}
\usage{
anim_prep_cat(
  data,
  id = NULL,
  values = NULL,
  time = NULL,
  group = NULL,
  order = NULL,
  label = NULL
)
}
\arguments{
\item{data}{A data frame contained the category values.}

\item{id}{The column name that represents the identifiers variable.}

\item{values}{The column name contains the category values.}

\item{time}{The column name that represents the time variable.}

\item{group}{The column name that represents the distinguished group between
the values.}

\item{order}{A vector of order for sorting the category values.}

\item{label}{A vector of labels to represent the qtile.}
}
\value{
A categorized data.
}
\description{
This function transformed the category data in the categorized format by
ordering the values.
}
\details{
The function takes the input data, ordering the values, and assigning the
variable names.
}
\examples{
anim_prep_cat(data = aeles, id = id, values = party, time = year)

}
