% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c14_validate.R
\name{c14_validate}
\alias{c14_validate}
\title{Check Calibrated Radiocarbon Dates}
\usage{
c14_validate(object, verbose = getOption("ananke.verbose"))
}
\arguments{
\item{object}{A \code{\linkS4class{CalibratedAges}} object.}

\item{verbose}{A \code{\link{logical}} scalar: should extra information be reported?}
}
\value{
\code{c14_validate()} is called it for its side-effects: it prints
\link[=warnings]{warning messages} if calibrated ages are (partially) out of
calibration range. Invisibly returns \code{x}.
}
\description{
Check Calibrated Radiocarbon Dates
}
\examples{
## Calibrate a single date
cal <- c14_calibrate(300, 20)
plot(cal, panel.first = graphics::grid())

## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)
plot(cal, panel.first = graphics::grid())

\donttest{
## Out of 14C range?
out <- c14_calibrate(130, 20)
plot(out)
}
}
\author{
N. Frerebeau
}
\keyword{internal}
