% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{flag_fast_steps}
\alias{flag_fast_steps}
\alias{flag_fast_steps.track_xyt}
\title{Flag Fast Steps}
\usage{
flag_fast_steps(x, delta, time_unit = "secs", ...)

\method{flag_fast_steps}{track_xyt}(x, delta, time_unit = "secs", ...)
}
\arguments{
\item{x}{\verb{[track_xyt]} A \code{track_xyt} object.}

\item{delta}{\verb{[numeric]} The threshold SDR over which steps are flagged.
See details.}

\item{time_unit}{\verb{[character]} Character string giving time unit. Should be
\code{"secs"}, \code{"mins"}, or \code{"hours"}. See details.}

\item{...}{Addtional arguments. None currently implemented.}
}
\value{
Returns \code{x} (a \code{track_xyt}) with a flagging column added
(\code{x$fast_step_}).
}
\description{
Flags locations that imply SDR exceeding a threshold
}
\details{
Locations are flagged if the SDR from the previous location to the
current location exceeds \code{delta}. Internally, flagged locations are dropped
from future consideration.

The \code{time_unit} should be the same time unit with which the SDR threshold
was calculated. SDR is typically calculated in \code{m^2/s}, so \code{time_unit} defaults
to \code{"secs"}. The spatial unit is determined by the CRS, which should typically
be in meters.
}
\seealso{
\code{\link{flag_duplicates}()}, \code{\link{flag_roundtrips}()},
\code{\link{flag_defunct_clusters}()}
}
\author{
Brian J. Smith, based on code by Johannes Signer and Tal Avgar
}
