% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meld_pre_2016.R
\name{meld_pre_2016}
\alias{meld_pre_2016}
\title{MELD Score (Original, Pre-2016, Model for End-Stage Liver Disease)}
\usage{
meld_pre_2016(my_data)
}
\arguments{
\item{my_data}{A data frame containing columns 'Creatinine', 'Bilirubin', 'INR', and 'Hemodialysis'.}
}
\value{
A modified data frame with the calculated MELD score and risk classification of three-month mortality. Returns NA for cases with missing values.
}
\description{
Calculates the MELD score based on the original pre-2016 formula, which does not include serum sodium levels, as used by non-US transplant societies.
Visit \url{https://www.mdcalc.com/calc/2693/meld-score-original-pre-2016-model-end-stage-liver-disease} for more information.
}
\details{
This function calculates the MELD score using the following parameters:
\itemize{
\item \code{Bilirubin : } Numeric value representing the bilirubin level (mg/dL).
\item \code{INR :} Numeric value representing the International Normalized Ratio (INR).
\item \code{Creatinine :} Numeric value representing the creatinine level (mg/dL).
\item \code{Hemodialysis :} Logical value indicating if the patient is on hemodialysis (0 = No, 1 = Yes).
}
}
\examples{
my_data <- data.frame(
  Hemodialysis = c(0, 0, 1),
  Creatinine = c(1.2, 0.9, 1.5),
  Bilirubin = c(0.7, 1.1, 0.9),
  INR = c(1.0, 1.2, 1)
)

meld_pre_2016(my_data)
}
\references{
Kamath et al. (2001) \url{doi:10.1053/jhep.2001.22172}
}
