% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{asymptotic_variance_est}
\alias{asymptotic_variance_est}
\title{Estimating the asymptotic variance in the trawl function CLT}
\usage{
asymptotic_variance_est(t, c4, varlevyseed = 1, Delta, avector, N = NULL)
}
\arguments{
\item{t}{The time point at which to compute the asymptotic variance}

\item{c4}{The fourth cumulant of the Levy seed of the trawl process}

\item{varlevyseed}{The variance of the Levy seed of the trawl process,
the default is 1}

\item{Delta}{The width Delta of the observation grid}

\item{avector}{The vector \eqn{(\hat a(0), \hat a(\Delta_n),
..., \hat a((n-1)\Delta_n))}}

\item{N}{The optional parameter to specify the upper bound \eqn{N_n} in the
computations of the estimators}
}
\value{
The estimated asymptotic variance \eqn{\hat v=\hat \sigma_a^2(t)}
and its components \eqn{\hat v_1, \hat v_2, \hat v_3, \hat v_4}.
}
\description{
This function estimates the asymptotic variance which appears in the
CLT for the trawl function estimation.
}
\details{
As derived in
Sauri and Veraart (2022), the estimated asymptotic variance is given by
\deqn{\hat \sigma^2_a(t)=\hat v_1(t)+\hat v_2(t)+\hat v_3(t)+\hat v_4(t),}
where
\deqn{\hat{v}_{1}(t):=\widehat{c_{4}(L')}\hat{a}(t)=RQ_n\hat{a}(t)/
\hat{a}(0),}
for
\deqn{RQ_n:=\frac{1}{\sqrt{2 n\Delta_{n}}}
\sum_{k=0}^{n-2}(X_{(k+1)\Delta_n}-X_{k\Delta_n})^4,}
and
\deqn{	\hat{v}_{2}(t):=2\sum_{l=0}^{N_{n}}\hat{a}^{2}(l\Delta_{n})
\Delta_{n},}
\deqn{	\hat{v}_{3}(t):=2\sum_{l=0}^{\min\{i,n-1-i\}}\hat{a}((i-l)\Delta_{n})
\hat{a}((i+l)\Delta_{n})\Delta_{n},}
\deqn{	\hat{v}_{4}(t):=-2\sum_{l=i}^{N_{n}-i}\hat{a}((l-i)\Delta_{n})
\hat{a}((i+l)\Delta_{n})\Delta_{n}.}
}
\examples{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 1000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(123)
#Simulate the trawl process
Poi_data <- sim_weighted_trawl(my_n, my_delta,
                               "Exp", my_lambda, "Poi", my_v)$path

#Estimate the trawl function
my_lag <- 100+1
trawl <- nonpar_trawlest(Poi_data, my_delta, lag=my_lag)$a_hat

#Estimate the fourth cumulant of the trawl process
c4_est <- c4est(Poi_data, my_delta)

asymptotic_variance_est(t=1, c4=c4_est, varlevyseed=1,
                        Delta=my_delta, avector=trawl)$v



}
