% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAB_plot.R
\name{JAB_plot}
\alias{JAB_plot}
\title{Plots JAB as a function of the p-value}
\usage{
JAB_plot(n, BF = 1, method = "JAB")
}
\arguments{
\item{n}{Sample size}

\item{BF}{Bayes factor you would like to match. 1 to avoid the Lindley Paradox, 3 to achieve moderate evidence and 10 to achieve strong evidence.}

\item{method}{Used for the choice of 'b'. Currently one of:
\itemize{
\item "JAB": this choice of b produces Jeffery's approximate BF
\item "min": uses the minimal training sample for the prior (Gu et al., '17)
\item "robust": a robust version of "min" that prevents too small b (O'Hagan, '95)
\item "balanced": this choice of b balances the type I and type II errors
}}
}
\value{
Prints a plot.
}
\description{
Plots JAB as a function of the p-value
}
\examples{
# Plot JAB as function of the p-value for a sample size of 2000
JAB_plot(2000)
}
