% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almanac-deprecated.R
\name{deprecated-recur}
\alias{deprecated-recur}
\alias{recur_on_mday}
\alias{recur_on_wday}
\alias{recur_on_yday}
\alias{recur_on_yweek}
\alias{recur_on_ymonth}
\title{Deprecated recurrence helpers}
\usage{
recur_on_mday(x, mday)

recur_on_wday(x, wday, nth = NULL)

recur_on_yday(x, yday)

recur_on_yweek(x, yweek)

recur_on_ymonth(x, ymonth)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{mday}{\verb{[integer]}

The days of the month on which to recur. Negative values are allowed,
which specify \code{n} days from the end of the month.}

\item{wday}{\verb{[integer / character]}

Days of the week to recur on. Integer values must be from \code{1} to \code{7}, with
\code{1 = Monday} and \code{7 = Sunday}. This is also allowed to be a full weekday
string like \code{"Tuesday"}, or an abbreviation like \code{"Tues"}.}

\item{nth}{\verb{[integer / NULL]}

Limit to the n-th occurrence of the \code{day} in the base frequency. For
example, in a monthly frequency, using \code{nth = -1} would limit to the
last \code{day} in the month. The default of \code{NULL} chooses all occurrences.}

\item{yweek}{\verb{[integer]}

Weeks of the year to recur on. Integer values must be between
\verb{[1, 53]} or \verb{[-53, -1]}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\itemize{
\item \code{recur_on_mday()} is deprecated as of almanac 1.0.0 in favor of
\code{\link[=recur_on_day_of_month]{recur_on_day_of_month()}}.
\item \code{recur_on_wday()} is deprecated as of almanac 1.0.0 in favor of
\code{\link[=recur_on_day_of_week]{recur_on_day_of_week()}}.
\item \code{recur_on_yday()} is deprecated as of almanac 1.0.0 in favor of
\code{\link[=recur_on_day_of_year]{recur_on_day_of_year()}}.
\item \code{recur_on_yweek()} is deprecated as of almanac 1.0.0 in favor of
\code{\link[=recur_on_week_of_year]{recur_on_week_of_year()}}.
\item \code{recur_on_ymonth()} is deprecated as of almanac 1.0.0 in favor of
\code{\link[=recur_on_month_of_year]{recur_on_month_of_year()}}.
}
}
\keyword{internal}
