% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALEPlots_methods.R
\name{subset.ALEPlots}
\alias{subset.ALEPlots}
\title{subset method for ALEPlots object}
\arguments{
\item{x}{An object of class \code{ALEPlots}.}

\item{...}{not used. Inserted to require explicit naming of subsequent arguments.}

\item{include_eff}{logical(1). \code{x_cols} and \code{exclude_cols} specify precisely which variables to include or exclude in the subset. However, multivariable plots like ALE effects plot are ambiguous because they cannot be subsetted to remove some existing variables. \code{include_eff = TRUE} (default) includes the ALE effects plot in the subset rather than dropping it, if it is available.}
}
\value{
An \code{ALEPlots} object reduced to cover only variables and interactions specified by \code{x_cols} and \code{exclude_cols}. This is different from \code{\link[=get.ALEPlots]{get.ALEPlots()}}, which returns a list of \code{ggplot} objects and loses the special \code{ALEPlots} behaviour like plotting, printing, and summarizing multiple plots.
}
\description{
Subset an \code{ALEPlots} object to produce another \code{ALEPlots} object only with the subsetted \code{x_cols} variables and interactions, as specified in the return value description.

See \code{\link[=get.ALE]{get.ALE()}} for explanation of parameters not described here.
}
