% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returnAKIpatients.R
\name{returnAKIpatients}
\alias{returnAKIpatients}
\title{Flag patients for AKI}
\usage{
returnAKIpatients(
  dataframe,
  HB_trumping = FALSE,
  eGFR_impute = FALSE,
  window1 = as.difftime(2, units = "days"),
  window2 = as.difftime(7, units = "days"),
  padding = as.difftime(0, units = "days"),
  add_min_creat = FALSE,
  add_baseline_creat = FALSE,
  add_imputed_admission = FALSE,
  add_imputed_encounter = FALSE
)
}
\arguments{
\item{dataframe}{patient dataset}

\item{HB_trumping}{boolean on whether to have historical baseline creatinine values trump the local minimum creatinine values}

\item{eGFR_impute}{boolean on whether to impute missing baseline creatinine values with CKD-EPI equation}

\item{window1}{rolling window length of the shorter time window; defaults to 48 hours}

\item{window2}{rolling window length of the longer time window; defaults to 162 hours}

\item{padding}{padding to add to rolling windows; defaults to 0 hours}

\item{add_min_creat}{boolean on whether to add the intermediate columns generated during calculation}

\item{add_baseline_creat}{boolean on whether to add the baseline creatinine values in}

\item{add_imputed_admission}{boolean on whether to add the imputed admission column in}

\item{add_imputed_encounter}{boolean on whether to add the imputer encounter id column in}
}
\value{
patient dataset with AKI column added in

#Imports
}
\description{
Add in the AKI column in a patient dataframe according to the  KDIGO criterion
}
\examples{
returnAKIpatients(toy)
}
