% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertMeteoSD.R
\name{ConvertMeteoSD}
\alias{ConvertMeteoSD}
\alias{ConvertMeteoSD.GRiwrm}
\alias{ConvertMeteoSD.character}
\alias{ConvertMeteoSD.matrix}
\title{Conversion of meteorological data from basin scale to sub-basin scale}
\usage{
ConvertMeteoSD(x, ...)

\method{ConvertMeteoSD}{GRiwrm}(x, meteo, ...)

\method{ConvertMeteoSD}{character}(x, griwrm, meteo, ...)

\method{ConvertMeteoSD}{matrix}(x, areas, temperature = FALSE, ...)
}
\arguments{
\item{x}{either a \code{GRiwrm} network description (See \link{CreateGRiwrm}), a \link{character} id of a node, or a \link{matrix} containing meteorological data}

\item{...}{Parameters passed to the methods}

\item{meteo}{\link{matrix} or \link{data.frame} containing meteorological data. Its \link{colnames} should be equal to the ID of the basins}

\item{griwrm}{\code{GRiwrm} object describing the semi-distributed network (See \link{CreateGRiwrm})}

\item{areas}{\link{numeric} vector with the total area of the basin followed by the areas of the upstream basins in km2}

\item{temperature}{\link{logical} \code{TRUE} if the meteorological data contain air temperature. If \code{FALSE} minimum output values are bounded to zero}
}
\value{
\link{matrix} a matrix containing the converted meteorological data
}
\description{
Conversion of meteorological data from basin scale to sub-basin scale
}
\seealso{
\code{\link[=CreateGRiwrm]{CreateGRiwrm()}}, \code{\link[=CreateInputsModel.GRiwrm]{CreateInputsModel.GRiwrm()}}
}
