% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist.R
\name{BootstrapAPCEipw}
\alias{BootstrapAPCEipw}
\title{Bootstrap for estimating variance of APCE}
\usage{
BootstrapAPCEipw(data, rep = 1000)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} of which columns consists of pre-treatment covariates, a binary treatment (Z), an ordinal decision (D), and an outcome variable (Y). The column names of the latter three should be specified as "Z", "D", and "Y" respectively.}

\item{rep}{Size of bootstrap}
}
\value{
An object of class \code{list} with the following elements:
\item{P.D1.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(1)=d| R=r), dimension 1 is rep (size of bootstrap), dimension 2 is (k+1) values of D from 0 to k, dimension 3 is (k+2) values of R from 0 to k+1.}
\item{P.D0.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(0)=d| R=r).}
\item{APCE.boot}{An array with dimension rep by (k+1) by (k+2) for quantity P(D(1)=d| R=r)-P(D(0)=d| R=r).}
\item{P.R.boot}{An array with dimension rep by (k+2) for quantity P(R=r) for r from 0 to (k+1).}
\item{alpha.boot}{An array with estimated alpha for each bootstrap.}
\item{delta.boot}{An array with estimated delta for each bootstrap.}
}
\description{
Estimate variance of APCE for frequentist analysis using bootstrap. See S7 for more details.
}
\examples{
data(synth)
set.seed(123)
boot_apce <- BootstrapAPCEipw(synth, rep = 100)

}
