% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftbybmv.R
\name{aftbybmv}
\alias{aftbybmv}
\title{Bayesian multivariate analysis of parametric AFT model with minimum deviance (DIC) among
 weibull, log normal and log logistic distribution.}
\usage{
aftbybmv(m, n, STime, Event, nc, ni, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data.}

\item{Event}{name of event in data. 0 is for censored and 1 for occurrence of event.}

\item{nc}{number of MCMC chain.}

\item{ni}{number of MCMC iteration to update the outcome.}

\item{data}{High dimensional gene expression data that contains event status, survival time and and set of covariates.}
}
\value{
Data frame is containing posterior estimates mean, sd, credible intervals, n.eff and Rhat for beta's, sigma, tau and deviance of the model for the selected covariates. beta's of regression coefficient of the model. beta[1] is for intercept and others are for covariates (which is/are chosen order as columns in data). 'sigma' is the scale parameter of the distribution. DIC is the estimate of expected predictive error (so lower deviance denotes better estimation).
}
\description{
Provides better estimates (which has minimum deviance(DIC) ) for survival data among weibull,
log normal and log logistic distribution of parametric AFT model using MCMC for
multivariable (maximum 5 at a time) in high dimensional data.
}
\details{
This function deals covariates (in data) with missing values. Missing value in any column (covariate) is replaced by mean of that particular covariate.
AFT model is log-linear regression model for survival time \eqn{ T_{1}},\eqn{ T_{2}},..,\eqn{T_{n}}.
i.e., \deqn{log(T_i)= x_i'\beta +\sigma\epsilon_i ;~\epsilon_i \sim F_\epsilon (.)~which~is~iid }
i.e., \deqn{T_i \sim AFT(F_\epsilon ,\beta,\tau|x_i)}
Where \eqn{ F_\epsilon } is known cdf which is defined on real line.
Here, when baseline distribution is extreme value then T follows weibull distribution.
To make interpretation of regression coefficients simpler, using extreme value distribution with median 0.
So using weibull distribution that leads to AFT model when
\deqn{ T \sim Weib(\sqrt{\tau},log(2)\exp(-x'\beta \sqrt{\tau})) }

When baseline distribution is normal then T follows log normal distribution.
\deqn{ T \sim LN(x'\beta,1/\tau) }
When baseline distribution is logistic then T follows log logistic distribution.
\deqn{ T \sim Log-Logis(x'\beta,\sqrt{\tau)} }
}
\examples{
##
data(hdata)
aftbybmv(10,12,STime="os",Event="death",2,100,hdata)
##
}
\references{
Prabhash et al(2016) <doi:10.21307/stattrans-2016-046>
}
\seealso{
wbysmv, lgnbymv, lgstbymv
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
