% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{graphics}
\alias{graphics}
\alias{plot.Coord1D}
\alias{points.Coord1D}
\alias{lines.Point1D}
\alias{plot.Coord2D}
\alias{points.Coord2D}
\alias{lines.Line2D}
\title{Plot coordinates, points, lines, and planes}
\usage{
\method{plot}{Coord1D}(x, ...)

\method{points}{Coord1D}(x, ...)

\method{lines}{Point1D}(x, ...)

\method{plot}{Coord2D}(x, ...)

\method{points}{Coord2D}(x, ...)

\method{lines}{Line2D}(x, ...)
}
\arguments{
\item{x}{A supported object to plot.}

\item{...}{Passed to the underlying plot method.}
}
\value{
Used for its side effect of drawing to the graphics device.
}
\description{
\code{\link[=plot]{plot()}} plots \link{Coord1D} and \link{Coord2D} class objects while
\code{\link[=points]{points()}} draws \link{Coord1D} and \link{Coord2D} class objects
and \code{\link[=lines]{lines()}} draws \link{Point1D} and \link{Line2D} class objects to an existing plot.
If the suggested \link[ggplot2:ggplot2-package]{ggplot2} and \link[rgl:rgl-package]{rgl} packages are available we also register \code{\link[ggplot2:autolayer]{ggplot2::autolayer()}} methods for \link{Coord1D}, \link{Coord2D}, \link{Point1D}, and \link{Line2D} class objects and a \code{\link[rgl:plot3d]{rgl::plot3d()}} method for \link{Coord3D} class objects.
}
\examples{
c1 <- as_coord2d(x = 0, y = 1:10)
l <- as_line2d(a = 1, b = -1, c = 0) # y = x
c2 <- c1$clone()$reflect(l)
plot(c1, xlim = c(-1, 11), ylim = c(-1, 11),
     main = "2D reflection across a line")
lines(l)
points(c2, col = "red")

c1 <- as_coord2d(x = 1:10, y = 1:10)
l <- as_line2d(a = -1, b = 0, c = 0) # x = 0
c2 <- c1$clone()$project(l)
if (require("ggplot2", quietly = TRUE,
            include.only = c("ggplot", "autolayer", "labs"))) {
  ggplot() +
      autolayer(c1) +
      autolayer(l) +
      autolayer(c2, color = "red") +
      labs(title = "2D projection onto a line")
}

c1 <- as_coord1d(x = seq.int(-4, -1))
pt <- as_point1d(a = 1, b = 0) # x = 0
c2 <- c1$clone()$reflect(pt)
plot(c1, xlim = c(-5, 5), main = "1D reflection across a point")
lines(pt)
points(c2, col = "red")

# 3D reflection across a plane
c1 <- as_coord3d(x = 1:10, y = 1:10, z = 1:10)
pl <- as_plane3d(a = 0, b = 0, c = -1, d = 2) # z = 2
c2 <- c1$clone()$reflect(pl)
if (require("rgl", quietly = TRUE,
            include.only = c("plot3d", "planes3d", "points3d"))) {
  plot3d(c1, size = 8)
  planes3d(as.data.frame(pl), d =  pl$d, color = "grey", alpha = 0.6)
  points3d(as.data.frame(c2), col = "red", size = 8)
}
}
