% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_cont_to_multiadm.R
\name{strat_cont_to_multiadm}
\alias{strat_cont_to_multiadm}
\title{estimate age-depth model from tracer}
\usage{
strat_cont_to_multiadm(
  h_tp,
  t_tp,
  strat_cont_gen,
  time_cont_gen,
  h,
  no_of_rep = 100L,
  subdivisions = 100L,
  stop.on.error = TRUE,
  T_unit = NULL,
  L_unit = NULL
)
}
\arguments{
\item{h_tp}{function, returning tie point heights}

\item{t_tp}{function, returning tie points times}

\item{strat_cont_gen}{function, describing tracer data observed in the section}

\item{time_cont_gen}{function, describing tracer changes in time}

\item{h}{numeric vector, heights where the age depth model is described}

\item{no_of_rep}{integer, number of age depth models generated}

\item{subdivisions}{integer, max no. of subintervals used by integration procedure. passed to \emph{integrate}, see ?stats::integrate for details}

\item{stop.on.error}{logical passed to \emph{integrate}, see ?stats::integrate for details}

\item{T_unit}{NULL or character, time unit}

\item{L_unit}{NULL or character, length unit}
}
\value{
Object of class multiadm
}
\description{
Estimates age-depth models by comparing observed tracer values in a section with assumptions on tracer flux in time. See \code{vignette("adm_from_trace_cont")} for a full example.
}
\examples{
\dontrun{
# see this vignette for an example
vignette("adm_from_trace_cont")
}

}
