% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abe.R
\name{pie.abe}
\alias{pie.abe}
\title{Pie Function}
\usage{
pie.abe(x, alpha = NULL, tau = NULL, labels = NA, ...)
}
\arguments{
\item{x}{an object of class `"abe"`, an object returned by a call to [abe.resampling()]}

\item{alpha}{values of alpha for which the plot is to be made (can be a vector of length >1)}

\item{tau}{values of tau for which the plot is to be made (can be a vector of length >1)}

\item{labels}{plot labels, defaults to NA, i.e. no labels are ploted}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see [pie()], [barplot()], [hist()]).}
}
\description{
Pie function for the resampled/bootstrapped version of ABE. Plots a pie chart of the model frequencies for specified values of `alpha` and `tau`.
}
\details{
When using `type.resampling="Wallisch2021"` the plot is based on subsampling with sampling proportion equal to 0.5, otherwise as specified in `type.resampling`.
}
\examples{
set.seed(10)
n = 100
x1 <- runif(n)
x2 <- runif(n)
x3 <- runif(n)
y <- -5 + 5 * x1 + 5 * x2 + rnorm(n, sd = 5)
dd <- data.frame(y = y, x1 = x1, x2 = x2, x3 = x3)
fit <- lm(y ~ x1 + x2 + x3, x = TRUE, y = TRUE, data = dd)

fit.resample <- abe.resampling(fit, data = dd, include = "x1", active = "x2",
tau = c(0.05, 0.1), exact = TRUE, criterion = "alpha", alpha = c(0.2, 0.05),
type.test = "Chisq", num.resamples = 50, type.resampling = "Wallisch2021")

pie.abe(fit.resample, alpha = 0.2, tau = 0.1)

fit.resample <- abe.resampling(fit, data = dd, include = "x1", active = "x2",
tau=  c(0.05, 0.1), exact=TRUE, criterion = "alpha", alpha = c(0.2, 0.05),
type.test = "Chisq", num.resamples = 50, type.resampling = "subsampling")

pie.abe(fit.resample, alpha = 0.2, tau = 0.1)
}
\seealso{
\link{abe.resampling}, \link{summary.abe}, \link{plot.abe}
}
\author{
Rok Blagus, \email{rok.blagus@mf.uni-lj.si}

Sladana Babic
}
