% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{bray_curtis}
\alias{bray_curtis}
\title{Bray-Curtis distance}
\usage{
bray_curtis(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The Bray-Curtis distance between \code{x} and \code{y}. The
  Bray-Curtis distance is undefined if the sum of all elements in \code{x}
  and \code{y} is zero, in which case we return \code{NaN}.
}
\description{
The Bray-Curtis distance is the Manhattan distance divided by the sum of
both vectors.
}
\details{
For two vectors \code{x} and \code{y}, the Bray-Curtis distance is defined
as \deqn{d(x, y) = \frac{\sum_i |x_i - y_i|}{\sum_i x_i + y_i}.} The
Bray-Curtis distance is connected to many other distance measures in this
package; we try to list some of the more important connections here. Relation
to other definitions:
\itemize{
  \item Equivalent to \code{vegdist()} with \code{method = "bray"}.
  \item Equivalent to the \code{braycurtis()} function in
    \code{scipy.spatial.distance} for positive vectors. They take the
    absolute value of \eqn{x_i + y_i} in the denominator.
  \item Equivalent to the \code{braycurtis} and \code{odum} calculators in
    Mothur.
  \item Equivalent to \eqn{D_{14} = 1 - S_{17}}{D_14 = 1 - S_17} in
    Legendre & Legendre.
  \item The Bray-Curtis distance on proportions is equal to half the
    Manhattan distance.
  \item The Bray-Curtis distance on presence/absence vectors is equal to the
    Sorenson index of dissimilarity.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
y <- c(10, 2, 0, 1, 1, 0)
bray_curtis(x, y)

# For proportions, equal to half the Manhattan distance
bray_curtis(x / sum(x), y / sum(y))
manhattan(x / sum(x), y / sum(y)) / 2
}
