% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{GreatTitMalaria}
\alias{GreatTitMalaria}
\title{Malaria in Populations of Great Tit}
\format{A data frame with 65 observations on the following 2 variables.
\describe{ \item{treatment}{a factor with levels \code{Control} and
\code{Egg removal}} \item{response}{a ordered factor with levels
\code{No Malaria} and \code{Malaria}} }}
\source{
Oppliger, A., P. Christe, and H. Richner. 1996. Clutch size and
malaria resistance. \emph{Nature} 381: 565.
}
\description{
Two-by-two contingency table of malaria (\emph{Plasmodium}) infection status
in control and egg-removal populations of Great Tit (\emph{Parus major}).
}
\examples{
str(GreatTitMalaria)

table(GreatTitMalaria)

if(require(vcd)) {
  mosaic(~treatment + response, GreatTitMalaria)
}
}
\references{
\url{http://www.nature.com/nature/journal/v381/n6583/abs/381565a0.html}
}
\keyword{datasets}

