% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aMNLFA_DIFplot.R
\name{aMNLFA.DIFplot}
\alias{aMNLFA.DIFplot}
\title{aMNLFA plotting function for aMNLFA.prune() results}
\usage{
aMNLFA.DIFplot(diflist, diftype, log = FALSE)
}
\arguments{
\item{diflist}{The listing of results from aMNLFA.prune(), which contains the DIF tables (as well as impact tables, which aren't used here)}

\item{diftype}{The type of DIF the user wants plot for. Options include "loading" (for loading DIF), "intercept" (for intercept DIF when threshold DIF is not tested), "threshold.highest" (which uses only the largest test statistic across all categories when threshold DIF is tested), and "threshold.all" (which uses the test statistic for all categories when threshold DIF is tested)}

\item{log}{Logical. If TRUE, plot the y axis on a log scale. Defaults to FALSE.}
}
\value{
No return value; generates a plot using base R.
}
\description{
This function gives the user a plot corresponding to loading, intercept, or threshold DIF from the aMNLFA.prune() function
}
\examples{
 \dontrun{
 wd <- tempdir()
 first<-paste0(system.file(package='aMNLFA'),"/extdata")
 the.list <- list.files(first,full.names=TRUE)
 file.copy(the.list,wd,overwrite=TRUE)
   
 ob <- aMNLFA::aMNLFA.object(dir = wd, 
 mrdata = xstudy, 
 indicators = paste0("BIN_", 1:12),
 catindicators = paste0("BIN_", 1:12), 
 meanimpact = c("AGE", "GENDER", "STUDY"), 
 varimpact = c("AGE", "GENDER", "STUDY"), 
 measinvar = c("AGE", "GENDER", "STUDY"),
 factors = c("GENDER", "STUDY"),
 ID = "ID",
 thresholds = FALSE)
 
 prune.object <- aMNLFA.prune(ob)
 aMNLFA.DIFplot(prune.object, "loading", log = FALSE)
 }
}
\keyword{MNLFA}
