% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPG_main.R
\name{ZIPG_simulate}
\alias{ZIPG_simulate}
\title{Simulate W from ZIPG model}
\usage{
ZIPG_simulate(
  M,
  X,
  X_star,
  A = 1,
  d,
  d_star,
  parms,
  N,
  zi = TRUE,
  returnU = FALSE
)
}
\arguments{
\item{M}{Sequencing depth}

\item{X}{Covariates matrix with intercept, n * (d+1)}

\item{X_star}{Covariates matrix with intercept, n * (d_star+1)}

\item{A}{no use, reserved for multi-taxa}

\item{d}{number of covariates in X}

\item{d_star}{number of covariates in X_star}

\item{parms}{model paraneters, input c(beta,beta*,gamma)}

\item{N}{repetition times}

\item{zi}{whether generate zero-inflated distribution}

\item{returnU}{whether return fluctuation factor U}
}
\value{
A list of W generated from ZIPG model with input parameter
}
\description{
Simulate W from ZIPG model
}
\examples{
data(Dietary)
dat = Dietary
sim_M = sample(dat$M,100,replace = TRUE)
sim_pre = rep(sample(rep(c(0,1),each = 10)),each = 5)
sim_PC1_mean = rep(rnorm(20,mean = 0,sd = 1),each = 5)
sim_PC1_error = rnorm(100,0,0.1)
sim_PC1 = sim_PC1_mean + sim_PC1_error
X = as.matrix(cbind(1,data.frame(X1 = sim_pre,X2 = sim_PC1)))
parms = c(-4.23,1,0.45,0.6,1,0,0) #p = 0.5
W_sim <- ZIPG_simulate(M = sim_M,X=X,X_star=X,d=2,d_star=2,parms = parms,N=100)
hist(W_sim$W_list[[1]])
ZIPG_res <- ZIPG_main(data = data.frame(X1 = sim_pre,X2 = sim_PC1),
X = ~X1+X2, X_star = ~ X1,W = W_sim$W_list[[2]], M = sim_M )
ZIPG_summary(ZIPG_res)
}
