% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_total.R
\name{compute_total}
\alias{compute_total}
\title{the bilateral (Left + Right) measures.}
\usage{
compute_total(
  data = sample_data,
  left_hemisphere = "lh",
  right_hemisphere = "rh",
  separator = "_",
  ID = "ID",
  hemisphere = "prefix",
  start,
  end
)
}
\arguments{
\item{data}{The wide format data}

\item{left_hemisphere}{The prefix or suffix that indicates the left hemisphere in the variable names}

\item{right_hemisphere}{The prefix or suffix string that indicate the right hemisphere in the variable names}

\item{separator}{A character vector that separates characters in the variable names.}

\item{ID}{The column of identifiers.}

\item{hemisphere}{The character vector that indicates whether a hemisphere indicator in the variable names is a prefix or suffix.}

\item{start}{The column that specifies the starting point of a set of variables to calculate the bilateral (L+R) measures.}

\item{end}{The column that specifies the endpoint of a set of variables to calculate the bilateral (L+R) measures.}
}
\value{
The data with the bilateral (L+R) measures.
}
\description{
compute_total() creates new columns that are the bilateral (Left + Right) measures.
}
\examples{

data(sample_data)

compute_total(sample_data,
left_hemisphere="lh",
right_hemisphere="rh",
separator="_",
ID="ID",
hemisphere="prefix",
start="lh_Thalamus",
end="rh_AccumbensArea")
}
