% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_extractor.R
\name{event_extractor}
\alias{event_extractor}
\title{Event extractor}
\usage{
event_extractor(data_df, ev0, ev1, evname)
}
\arguments{
\item{data_df}{data frame with events ev0 and ev1 (e.g., start of trial and reinforcement delivery)}

\item{ev0}{event ID start (where the event we want to extract begins)}

\item{ev1}{event ID stop. This event won't be returned, so keep in mind that}

\item{evname}{a string for the event name, for identification purposes. For example
if the event we want to extract is component 1 in a multiple-2 schedule,
this can be eventname = "c1", so when we extract the second
component we can row-combine both in a unique dataframe.}
}
\value{
data frame with nrows x 4 columns of time, events, cum_id and evname
}
\description{
A function to slice data based on start and stop events. This function
should be used after read_med.r, which outputs a csv of 2 columns: time and
events (in that order). Its use is exemplified at the end of the function.
}
\details{
Works by trials
}
\examples{
# If we have a component starting with 5 and ending with 3, 
# say a Fixed Interval 15s and a dataframe of events from the read_med() function,
# we can extract the data of component "FI15" following the next steps:
# 0 - From the output of read_med.R function, load the extracted data and assign it to df
# 1 - source the event_extractor.R function
# 2 - use it with the appropiate arguments as follows

# read raw data from MED
data("fi60_raw_from_med")
# see first 10 lines
head(fi60_raw_from_med, 10)
# create a temporary file to avoid non-staged installation warning
temp_file <- tempfile(fileext = ".txt")
# write the data to the temporary file
writeLines(fi60_raw_from_med, temp_file)
# Process the file using read_med
example_processed <- read_med(
  fname = temp_file, save_file = FALSE,
  col_r = "C:", out = TRUE,
  col_names = c("time", "event"), num_col = 6, time_dot_event = TRUE
)

# Extract specific events (FI15 in this case)
extracted_FI15 <- event_extractor(
  data_df = example_processed,
  ev0 = 5, ev1 = 3,
  evname = "FI15"
)

# Display the first rows of the extracted data
head(extracted_FI15, 30)

}
