% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R
\name{review}
\alias{review}
\alias{review.coords}
\alias{review.waypoints}
\title{Review Coordinates and Waypoints Validity}
\usage{
review(x, ...)

\method{review}{coords}(x, ..., show_n = 20L)

\method{review}{waypoints}(x, ..., show_n = 20L)
}
\arguments{
\item{x}{object of class \code{"\link{coords}"} created by function \code{\link{as_coords}()}, or
class \code{"\link{waypoints}"} created by function \code{\link{as_waypoints}()}.}

\item{...}{further arguments passed to or from other methods.}

\item{show_n}{\code{integer}, the maximum number of invalid elements of argument \code{x} to
include in the output; default \code{20L}.}
}
\value{
The \code{review()} method for class \code{"coords"} returns a \code{\link[base:list]{list}}
comprising the following elements: -

\item{allvalid}{\code{logical}, whether or not all the elements of argument \code{x} are valid.}

\item{n_invalid}{\code{integer}, the number of invalid elements in argument \code{x}, if any.}

\item{invalids}{\code{numeric} vector including invalid elements of argument \code{x}, if any.}

\item{which_invalid}{\code{integer} vector specifying which elements of argument \code{x} are
  invalid, if any.}

The method for class \code{"waypoints"} returns a list of two sub-lists, each sub-list with
elements as described above for the method for class \code{"coords"}, one each for latitude and
longitude.
}
\description{
Review validity of elements of \code{"coords"} and \code{"waypoints"} objects.
}
\details{
\code{review()} reveals elements of \code{"coords"} and  \code{"waypoints"} objects that do not
conform to the criteria checked by \code{\link{validate}()}, i.e. are not valid geographic
locations.
}
\examples{
## Continuing example from `validate()`...
\dontshow{suppressWarnings(dm <- (\(){
    tmp <- as_coords(c(5160.4659, 4932.7726, 4806.4339, 3853.3696, 0.0000, -3706.7044, -5306.2869, -2514.4093,
        -007.6754, 1823.9137, -12246.7203, -7702.1145, 0.0000, -1217.3178, 7331.0370, -5731.1536), fmt = 2)
    names(tmp) <- rep(c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
        "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"), 2)
    latlon(tmp) <- rep(c(TRUE, FALSE), each = 8)
    tmp
})())}

## Review "coords" object in degrees and minutes, having
## an erroneous first value of more than 60 minutes
review(dm)

###
## Continuing example from `validate()`...
\dontshow{suppressWarnings(
   wp <- as_waypoints(data.frame(
       name = c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
                "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"),
       lat = c(51.507765, 49.54621, 48.107232, 38.889494, 0, -37.11174, -93.104781, -25.240156),
       lon = c(-0.127924, 18.398562, -122.778671, -77.035242, 0, -12.28863, 73.517283, -57.519227)
   ), fmt = 1)
)}

## Review "waypoints" object in  decimal degrees, having an erroneous
## penultimate latitude absolute value greater than 90 degrees
review(wp)

rm(dm, wp)

}
\seealso{
\code{"\link{coords}"} and \code{"\link{waypoints}"}.

Other validate: 
\code{\link{validate}()}
}
\concept{validate}
