% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletFittingarma.R
\name{WaveletFitting}
\alias{WaveletFitting}
\title{Wavelet Transform Using Maximal Overlap Discrete Wavelet Transform (MODWT) Algorithm}
\usage{
WaveletFitting(
  ts,
  WFilter = "haar",
  Wvlevels,
  bndry = "periodic",
  FFlag = TRUE
)
}
\arguments{
\item{ts}{Univariate time series}

\item{WFilter}{Wavelet filter use in the decomposition}

\item{Wvlevels}{The level of wavelet decomposition}

\item{bndry}{The boundary condition of wavelet decomposition:'periodic' or 'reflection'}

\item{FFlag}{The FastFlag condition of wavelet decomposition: True or False}
}
\value{
\itemize{
  \item WaveletSeries - The wavelet trasnform of the series
}
}
\description{
Transforms the time series data by using hybrid MODWT algorithm.
}
\examples{
data<-rnorm(100,mean=100,sd=50)
WaveletFitting(ts=data,Wvlevels=3,WFilter='haar',bndry='periodic',FFlag=TRUE)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2007. Forecasting time series using wavelets. Internationa Journal of Wavelets, Multiresolution and Inforamtion Processing, 5, 709 to 724
\item Percival D. B. and Walden A. T. 2000. Wavelet Methods for Time-Series Analysis. Cambridge Univ. Press, U.K.
\item Paul R. K., Prajneshu and Ghosh H. 2013. Wavelet Frequency Domain Approach for Modelling and Forecasting of Indian Monsoon Rainfall Time-Series Data. Journal of the Indian society of agricultural statistics, 67, 319 to 327.
}
}
