% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Waveletann.R
\name{WaveletFittingann}
\alias{WaveletFittingann}
\title{Wavelet-ANN Hybrid Model for Forecasting}
\usage{
WaveletFittingann(
  ts,
  Waveletlevels,
  Filter = "haar",
  boundary = "periodic",
  FastFlag = TRUE,
  nonseaslag,
  seaslag = 1,
  hidden,
  NForecast
)
}
\arguments{
\item{ts}{Univariate time series}

\item{Waveletlevels}{The level of wavelet decomposition}

\item{Filter}{Wavelet filter}

\item{boundary}{The boundary condition of wavelet decomposition}

\item{FastFlag}{The FastFlag condition of wavelet decomposition: True or False}

\item{nonseaslag}{Number of non seasonal lag}

\item{seaslag}{Number of non seasonal lag}

\item{hidden}{Size of the hidden layer}

\item{NForecast}{The forecast horizon: A positive integer}
}
\value{
\itemize{
  \item Finalforecast - Forecasted value
  \item FinalPrediction - Predicted value of train data
  \item Accuracy - RMSE and MAPE for train data
}
}
\description{
Wavelet-ANN Hybrid Model for Forecasting
}
\examples{
N <- 100
PHI <- 0.2
THETA <- 0.1
SD <- 1
M <- 0
D <- 0.2
Seed <- 123
set.seed(Seed)
Sim.Series <- fracdiff::fracdiff.sim(n = N,ar=c(PHI),ma=c(THETA),d=D,rand.gen =rnorm,sd=SD,mu=M)
simts <- as.ts(Sim.Series$series)
WaveletForecast<-WaveletFittingann(ts=simts,Waveletlevels=3,Filter='d4',
nonseaslag=5,hidden=3,NForecast=5)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2012. Nonstationary time series forecasting using wavelets and kernel smoothing. Communications in Statistics-Theory and Methods, 41(3),485-499.
\item Paul, R.K. A and Anjoy, P. 2018. Modeling fractionally integrated maximum temperature series in India in presence of structural break. Theory and Applied Climatology 134, 241–249.
}
}
