% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_rec.R
\name{WRrec}
\alias{WRrec}
\title{Generalized win ratio tests}
\usage{
WRrec(ID, time, status, trt, strata = NULL, naive = FALSE)
}
\arguments{
\item{ID}{A vector of unique patient identifiers.}

\item{time}{A numeric vector of event times.}

\item{status}{A vector of event type variable; 2 = recurrent event, 1 = death,
and 0 = censoring.}

\item{trt}{A vector of binary treatment indicators.}

\item{strata}{A vector of categorical variable for strata; Default is NULL,
which leads to unstratified analysis.}

\item{naive}{If TRUE, results for NWR and FWR will be provided in addition
to LWR; Default is FALSE, which gives LWR only.}
}
\value{
An object of class \code{WRrec}, which contains the following
elements.
\item{theta}{A bivariate vector of win/loss fractions by LWR.}
\item{log.WR, se}{Log-win ratio estimate and its standard error by LWR.}
\item{pval}{\eqn{p}-value by the LWR test.}
\item{theta.naive}{A bivariate vector of win/loss fractions by NWR.}
\item{log.WR.naive, se.naive}{Log-win ratio estimate and its standard error by NWR.}
\item{theta.FI}{A bivariate vector of win/loss fractions by FWR.}
\item{log.WR.FI, se.FI}{Log-win ratio estimate and its standard error by FWR.}
\item{...}{}
}
\description{
Perform stratified two-sample test of possibly recurrent nonfatal
event and death using the recommended last-event assisted win ratio (LWR), and/or
naive win ratio (NWR) and first-event assisted win ratio (FWR) (Mao et al., 2022).
The LWR and FWR reduce to the standard win ratio of Pocock et al. (2012).
}
\examples{
## load the HF-ACTION trial data
library(WR)
head(hfaction_cpx9)
dat<-hfaction_cpx9
## Comparing exercise training to usual care by LWR, FWR, and NWR
obj<-WRrec(ID=dat$patid,time=dat$time,status=dat$status,
          trt=dat$trt_ab,strata=dat$age60,naive=TRUE)
## print the results
obj
}
\references{
Mao, L., Kim, K. and Li, Y. (2022). On recurrent-event win ratio.
Statistical Methods in Medical Research, under review.

Pocock, S., Ariti, C., Collier, T., and Wang, D. (2012). The win ratio: a new approach
to the analysis of composite endpoints in clinical trials based on clinical priorities.
 European Heart Journal, 33, 176--182.
}
\seealso{
\code{\link{print.WRrec}}.
}
\keyword{WRrec}
