% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualPop-package.R
\docType{data}
\name{dLH}
\alias{dLH}
\title{Individual fertility histories based on period data and in the presence of mortality (USA 2021)}
\format{
A data frame with data about 7,000 individuals (2000 in initial cohort). \describe{
\item{ID}{Identification number} 	
\item{gen}{Generation}
\item{cohort}{Birth cohort (year of birth)}
\item{sex}{Sex. A factor with levels Males and Females}
\item{bdated}{Date of birth (decimal date)} 
\item{ddated}{Date of death (decimal date)} 
\item{x_D}{Age at death (decimal number)} 	
\item{IDmother}{ID of mother} 	
\item{IDfather}{ID of father}
\item{jch}{Child's line number in the nuclear family (household)}
\item{IDpartner}{ID of partner}
\item{udated}{Date of union formation}
\item{nch}{Number of children ever born to the individual}}	
The object has four attributes:
\itemize{
 \item Country
 \item type: Type of data used to produce the histories (period data or cohort data)
 \item refyear: Calendar year for which period data are used. If cohort data are used, refyear is missing (NA)
 \item cohort: Year of birth of cohort for which the data are used. If period data are used, cohort is missing (NA)
}
}
\source{
The virtual population is produced from period mortality rates by age and period
fertility rates by age and parity from the United States 2021. The data are from the Human
Mortality Database (HMD) and the Human Fertility Database (HFD).
}
\usage{
data(dLH,package="VirtualPop")
}
\description{
Fertility histories based on period data and in the presence of mortality. 
The histories are simulated from age-specific death rates and conditional fertility rates of USA 2021.
}
