% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_c.R
\name{visualize_c}
\alias{visualize_c}
\title{Visualization for Estimating c Bias}
\usage{
visualize_c(dlow, lower = TRUE, ribbon_color = "lightblue")
}
\arguments{
\item{dlow}{The lower limit of the possible effect size}

\item{lower}{Use this to indicate if you want the lower or upper bound
of d for one sided confidence intervals. If d is positive, you generally
want \code{lower = TRUE}, while negative d values should enter
\code{lower = FALSE} for the upper bound that is closer to zero.}

\item{ribbon_color}{background coloring for c values that support
a non-zero effect in sensitivity}
}
\value{
Returns a pretty graph

\item{graph}{The graph of possible values for c}
}
\description{
This function displays a visualization of the possible
bias c that allows for a non-zero effect in sensitivity.
}
\examples{

visualize_c(dlow = .25, lower = TRUE)

}
\keyword{effect}
\keyword{estimation}
\keyword{ggplot}
\keyword{size}
\keyword{visualization}
