% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lssVarReg_multi.R
\name{lssVarReg.multi}
\alias{lssVarReg.multi}
\title{Semi parametric location, shape and scale regression}
\usage{
lssVarReg.multi(
  y,
  x,
  locationmodel = c("constant", "linear", "semi"),
  location.vars = c(1),
  scale2model = c("constant", "linear", "semi"),
  scale2.vars = c(1),
  shapemodel = c("constant", "linear", "semi"),
  shape.vars = c(1),
  knots.l = NULL,
  knots.sc = NULL,
  knots.sh = NULL,
  degree = 2,
  location.init = NULL,
  scale2.init = NULL,
  shape.init = NULL,
  int.maxit = 1000,
  print.it = FALSE,
  control = list(...),
  ...
)
}
\arguments{
\item{y}{Vector containing outcome data. Must be no missing data.}

\item{x}{Matrix containing the covariate data, same length as \code{y}. Must be no missing data.}

\item{locationmodel}{Vector to specify the location model to be fit for each covariate. Options: \code{"constant"} = constant model (intercept only), \code{"linear"} = linear term with x covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.l}).}

\item{location.vars}{Vector to specify the column(s) in \code{x} referring to covariates to be fit in the location model, eg c(1,2) indicates columns 1 and 2 in \code{x}. Must be the same length as \code{locationmodel} which specifies if they are fit as linear/semi. If semi, use \code{knots.l} to specify knots.}

\item{scale2model}{Vector to specify the scale^2 model to be fit for each covariate. Options: \code{"constant"} = constant term only, \code{"linear"} = linear term with \code{x} covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.sc})}

\item{scale2.vars}{Vector to specify the column(s) in \code{x} referring to covariates to be fit in the scale^2 model, eg c(1,2) indicates columns 1 and 2 in \code{x}. Must be the same length as \code{scale2model} which specifies if they are fit as linear/semi. If semi, use \code{knots.sc} to specify knots.}

\item{shapemodel}{Vector to specify the shape model to be fit for each covariate. Options: \code{"constant"} = constant shape model, \code{"linear"} = linear term with x covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.sh}).}

\item{shape.vars}{Vector to specify the column(s) in \code{x} referring to covariates to be fit in the shape model, eg c(1,2) indicates columns 1 and 2 in \code{x}. Must be the same length as \code{shapemodel} which specifies if they are fit as linear/semi. If semi, use \code{knots.sh} to specify knots.}

\item{knots.l}{Vector indicating the number of internal knots to be fit in the location model for each covariate. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{knots.sc}{Vector indicating the number of internal knots to be fit in the scale^2 model for each covariate. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{knots.sh}{Vector indicating the number of internal knots to be fit in the shape model for each covariate. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{degree}{Integer to indicate the degree of the splines fit in the location, scale and shape.  Default is '2'.}

\item{location.init}{Vector of initial parameter estimates for the location model. Defaults to vector of 1's of appropriate length.}

\item{scale2.init}{Vector of initial parameter estimates for the scale^2 model. Defaults to vector of 1's of appropriate length.}

\item{shape.init}{Vector of initial parameter estimates for the shape model. Defaults to vector of 1's of appropriate length.}

\item{int.maxit}{Integer of maximum iterations for the internal location and scale EM algorithm. Default is 1000 iterations.}

\item{print.it}{Logical for printing progress of estimates through each iteration. Default is \code{FALSE}.}

\item{control}{List of control parameters for the algorithm. See \code{\link{VarReg.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied
directly}
}
\value{
\code{lssVarReg} returns an object of class \code{"lssVarReg"}, which inherits most from class
\code{"VarReg"}. This object of class \code{lssVarReg} is a list of the following components:
\itemize{
\item \code{modeltype}: Text indicating the model that was fit, always "LSS model" for this model.
\item \code{locationmodel}, \code{scale2model}, \code{shapemodel}, \code{knots.l}, \code{knots.sc},
\code{knots.sh}, \code{degree},\code{mono.scale} : Returning the input variables as described above
\item\code{converged}: Logical argument indicating if convergence occurred.
\item\code{iterations}: Total iterations performed of the main algorithm (not including the
 internal EM algorithm).
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{loglik}: Numeric variable of the maximised log-likelihood.
 \item\code{aic.c}: Akaike information criterion corrected for small samples
 \item\code{aic}: Akaike information criterion
 \item\code{bic}: Bayesian information criterion
 \item\code{hqc}: Hannan-Quinn information criterion
 \item\code{location}: Vector of the maximum likelihood estimates of the location parameters.
 \item\code{scale2}: Vector of the maximum likelihood estimates of the scale (squared) parameters.
 \item\code{shape}: Vector of the maximum likelihood estimates of the shape parameters.
 \item\code{data}: Dataframe containing the variables included in the model.
 }
}
\description{
\code{lssVarReg.multi} performs a semiparametric location (\eqn{\xi} or xi), shape (\eqn{\nu} or nu) and scale (\eqn{\omega} or omega) regression model. This is designed for multiple covariates that are fit in the location, scale and shape models.
}
\examples{
## not run
## library(palmerpenguins)
## cc<-na.omit(penguins)
## y<-cc$body_mass_g
## x<-as.data.frame(cbind(cc$bill_length_mm, cc$flipper_length_mm,cc$bill_depth_mm))
## colnames(x) <-c("bill length mm", "flipper length mm","bill depth mm")
## model1<-lssVarReg.multi(y, x,
##                         locationmodel="linear", location.vars = 2,
##                         scale2model="constant",
##                         shapemodel=c("linear", "semi"), shape.vars = c(2,3),
##                         knots.sh = 1, int.maxit=10 )
## model1[-21] ## print model
}
\seealso{
\code{\link{VarReg.control}}  \code{\link{plotlssVarReg}}
}
