% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vb_lap_local.R
\name{vb_lap_local}
\alias{vb_lap_local}
\title{Local Laplace VB}
\usage{
vb_lap_local(X, Z, Y, max_iter = 1000, tol = 1e-06, a = 1, b = 10, lambda = 1)
}
\arguments{
\item{X}{Homogeneous covariates}

\item{Z}{Heterogeneous covariates}

\item{Y}{Response covariates}

\item{max_iter}{Maximum number of iterations, Defaut:1000}

\item{tol}{Algorithm convergence tolerance, Defaut:1e-6}

\item{a}{A prior of Beta distribution, Defaut:1}

\item{b}{A prior of Beta distribution, Defaut:10}

\item{lambda}{A prior of Laplace distribution, Defaut:1}
}
\value{
The mean of the homogeneity coefficient:mu;
The variance of homogeneity coefficient:sigma;
Selection coefficient:gamma;
Mean and covariance of heterogeneity coefficients:m, s2.
}
\description{
A variational Bayesian algorithm, based on the Laplace Spike-and-Slab prior, is tailored for
multi-source heterogeneous models and focuses on variable selection exclusively for the
homogeneous covariates.
}
