% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrict_sh.R
\name{restrict_sh}
\alias{restrict_sh}
\title{Restricted VAR}
\usage{
restrict_sh(x, ...)
}
\arguments{
\item{x}{An object of class "varshrinkest"}

\item{...}{Other arguments to vars::restrict()}
}
\value{
An object of class "varest", a VAR model fitted using ordinary
least squares. It contains an additional element \code{restrictions}, which
is a zero-one matrix indicating which variables were fixed to zero.
}
\description{
Estimation of a VAR by imposing zero restrictions manually or by
significance.
}
\details{
This is a modification of \code{vars::restrict()} for the class
"varshrinkest". Given an estimated VAR object of class "varest" or
"varshrinkest", a restricted VAR is obtained by choosing \code{method} "ser"
or "manual". Note: this function fits a restricted VAR using ordinary least
squares rather than a shrinkage method.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
restrict_sh(estim)
}
\seealso{
\code{\link[vars]{restrict}}
}
