% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expansions.R
\name{bs_term}
\alias{bs_term}
\title{Term for a B-Spline Basis for Polynomial Splines}
\usage{
bs_term(
  x = numeric(),
  df = NULL,
  knots = NULL,
  degree = 3,
  intercept = FALSE,
  Boundary.knots = range(if (use_log) log(x) else x),
  use_log = FALSE
)
}
\arguments{
\item{x, df, knots, degree, intercept, Boundary.knots}{same as \code{\link{bs}}.}

\item{use_log}{\code{TRUE} if the polynomials should be in the log of the
argument.}
}
\value{
A list like \code{\link{bs}} with an additional element called \code{eval}
to evaluate the basis. See \code{\link{VAJointSurv-terms}}.
}
\description{
Term for a B-Spline Basis for Polynomial Splines
}
\examples{
vals <- c(0.41, 0.29, 0.44, 0.1, 0.18, 0.65, 0.29, 0.85, 0.36, 0.47)
spline_basis <- bs_term(vals,df = 3)
# evaluate spline basis at 0.5
spline_basis$eval(0.5)
# evaluate first derivative of spline basis at 0.5
spline_basis$eval(0.5, der = 1)
}
\seealso{
\code{\link{poly_term}}, \code{\link{ns_term}}, \code{\link{weighted_term}},
and \code{\link{stacked_term}}.
}
