% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us_congressional.R
\name{us_congressional}
\alias{us_congressional}
\title{Congressional district boundaries (contemporary)}
\usage{
us_congressional(resolution = c("low", "high"), states = NULL)
}
\arguments{
\item{resolution}{The resolution of the boundaries.}

\item{states}{A character vector of state or territory names. Only boundaries
inside these states/territories will be returned. If \code{NULL}, all
boundaries will be returned.}
}
\value{
An \code{sf} object.
}
\description{
Get the current (2024) boundaries for U.S. Congressional districts.
}
\examples{
if (require(USAboundariesData, quietly = TRUE) && require(sf, quietly = TRUE)) {
  us_congressional <- us_congressional()
  va_congressional <- us_congressional(
    states = "Virginia", resolution = "high")
  plot(st_geometry(us_congressional))
  plot(st_geometry(va_congressional))
}

}
\seealso{
For documentation of and citation to the underlying shapefiles for
  contemporary data from the U.S. Census Bureau, see the
  \code{census_boundaries} help file in the USAboundariesData package.
}
