% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QuickResults}
\alias{QuickResults}
\title{Quick pooled results}
\usage{
QuickResults(
  CDs,
  no.Donors = 8,
  dist = "GenLog",
  Qmed = NULL,
  UrbMax = 0.03,
  Include = NULL
)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or CDsXML}

\item{no.Donors}{number of donors required. The default is 8.}

\item{dist}{a choice of distribution for the estimates. The choices are "GenLog", "GEV", "Kappa3", or "Gumbel; the generalised logistic, generalised extreme value, Kappa3,and Gumbel distributions, respectively. The default is "GenLog"}

\item{Qmed}{user supplied QMED which overrides the default QMED estimate}

\item{UrbMax}{A maximum value for URBEXT2015 permitted in the pooling group. The default is 0.03.}

\item{Include}{A site reference for any site you want to ensure is in the pooling group if it is not chosen automatically. For example, a site which has URBEXT2015 above UrbMax.}
}
\value{
A list of length three. Element one is a data frame with columns; return period (RP), peak flow estimates (Q) and growth factor estimates (GF). The second element is the estimated Lcv and Lskew (linear coefficient of variation and skewness). The third element is a dataframe with the distribution parameters.
}
\description{
Provides pooled results, directly from the catchment descriptors
}
\details{
The quick results function provides results with a default pooling group. Sites are chosen from those with URBEXT2015 below or equal to UrbMax (the default is 0.03).The LCVs in the pooling group are 'de-urbanised'. The final LCV estimate is then urban adjusted. QMED is estimated using the QMED function with eight donors, all of which have a de-urbanised observed QMED for the donor process. Then the QMED estimate has an urban adjustment applied. If the CDs are for a site suitable for pooling/QMED, this QMED estimate converges to the observed.
}
\examples{
# Get some catchment descriptors
cds_73005 <- GetCDs(73005)

# Get results
QuickResults(cds_73005)

# Get results with a GEV distribution
QuickResults(cds_73005, dist = "GEV")


}
\author{
Anthony Hammond
}
