% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_identifier.R
\name{vis_identifier_multi_cor}
\alias{vis_identifier_multi_cor}
\title{Visualize Correlation for Multiple Identifiers}
\usage{
vis_identifier_multi_cor(
  dataset,
  ids,
  samples = NULL,
  matrix.type = c("full", "upper", "lower"),
  type = c("parametric", "nonparametric", "robust", "bayes"),
  partial = FALSE,
  sig.level = 0.05,
  p.adjust.method = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none"),
  color_low = "#E69F00",
  color_high = "#009E73",
  ...
)
}
\arguments{
\item{dataset}{the dataset to obtain identifiers.}

\item{ids}{the molecule identifiers.}

\item{samples}{default is \code{NULL}, can be common sample names for two datasets.}

\item{matrix.type}{Character, \code{"upper"} (default), \code{"lower"}, or \code{"full"},
display full matrix, lower triangular or upper triangular matrix.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{partial}{Can be \code{TRUE} for partial correlations. For Bayesian partial
correlations, "full" instead of pseudo-Bayesian partial correlations (i.e.,
Bayesian correlation based on frequentist partialization) are returned.}

\item{sig.level}{Significance level (Default: \code{0.05}). If the \emph{p}-value in
\emph{p}-value matrix is bigger than \code{sig.level}, then the corresponding
correlation coefficient is regarded as insignificant and flagged as such in
the plot.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{color_low}{the color code for lower value mapping.}

\item{color_high}{the color code for higher value mapping.}

\item{...}{other parameters passing to \link[ggstatsplot:ggcorrmat]{ggstatsplot::ggcorrmat}.}
}
\value{
a (gg)plot object.
}
\description{
NOTE: the dataset must be dense matrix in UCSC Xena data hubs.
}
\examples{
\dontrun{
dataset <- "TcgaTargetGtex_rsem_isoform_tpm"
ids <- c("TP53", "KRAS", "PTEN")
vis_identifier_multi_cor(dataset, ids)
}
}
