% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_cross.R
\name{vis_gene_cross_omics}
\alias{vis_gene_cross_omics}
\title{Visualize cross-omics of one gene among pan-cancers}
\usage{
vis_gene_cross_omics(
  gene = "TP53",
  tumor_projects = NULL,
  tumor_samples = NULL,
  n_trans = 5,
  n_methy = 5,
  seed = 42,
  add_mean_trans = TRUE,
  add_mean_methy = TRUE,
  pval_mrna = c(0.05, 0.01, 0.001),
  return_list = FALSE
)
}
\arguments{
\item{gene}{a gene symbol identifier (e.g., "TP53")}

\item{tumor_projects}{Select specific TCGA projects. Default NULL, indicating all TCGA projects.}

\item{tumor_samples}{Select specific tumor samples. Default NULL, indicating all tumor samples.}

\item{n_trans}{The number of sampling transcripts or specific transcript identifiers.}

\item{n_methy}{The number of sampling CpG sites or specific CpG identifiers.}

\item{seed}{The seed of sampling.}

\item{add_mean_trans}{Add overall column to display the mean values of all gene's transcripts.}

\item{add_mean_methy}{Add overall column to display the mean values of all gene's cpg sites.}

\item{pval_mrna}{The P value thresholds}

\item{return_list}{TRUE returns a list including plot object and data. FALSE just returns plot.}
}
\value{
funkyheatmap
}
\description{
Visualize cross-omics of one gene among pan-cancers
}
