% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haz2tsLMM_summary.R
\name{haz2tsLMM_summary}
\alias{haz2tsLMM_summary}
\title{Summary function for object of class 'haz2tsLMM'}
\usage{
haz2tsLMM_summary(x, ...)
}
\arguments{
\item{x}{an object of class 'haz2tsLMM' returned by the function \code{\link[=fit2ts]{fit2ts()}}}

\item{...}{further arguments}
}
\value{
a printed summary of the fitted model, including optimal smoothing
paramters, the effective dimension ED and the AIC/BIC. For model
with covariates, a regression table is also returned.
}
\description{
Summary function for object of class 'haz2tsLMM'
}
\examples{
# Create some fake data - the bare minimum
id <- 1:20
u <- c(
  5.43, 3.25, 8.15, 5.53, 7.28, 6.61, 5.91, 4.94, 4.25, 3.86, 4.05, 6.86,
  4.94, 4.46, 2.14, 7.56, 5.55, 7.60, 6.46, 4.96
)
s <- c(
  0.44, 4.89, 0.92, 1.81, 2.02, 1.55, 3.16, 6.36, 0.66, 2.02, 1.22, 3.96,
  7.07, 2.91, 3.38, 2.36, 1.74, 0.06, 5.76, 3.00
)
ev <- c(1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1) #'

fakedata <- as.data.frame(cbind(id, u, s, ev))
fakedata2ts <- prepare_data(data = fakedata,
                            u = "u",
                            s_out = "s",
                            ev = "ev",
                            ds = .5)
# Fit a fake model - not optimal smoothing
fakemod <- fit2ts(fakedata2ts,
  optim_method = "LMMsolver"
)
summary(fakemod)
}
