% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trueskillthroughtime.R
\name{Player}
\alias{Player}
\alias{performance}
\title{Player}
\usage{
Player(prior = Nms, beta = BETA, gamma = GAMMA)

performance(a)
}
\arguments{
\item{prior}{A Gaussian object, the prior belief distribution of the skills. The 
default value is: \code{Nms = Gaussian(mu = 0, sigma = 6)}.}

\item{beta}{A number, the standard deviation of the performance. The default 
value is: \code{BETA = 1}. The parameter \code{beta} acts as the scale of the 
estimates. A real difference of one \code{beta} between two skills is equivalent 
to 76\% probability of winning.}

\item{gamma}{A number, the amount of uncertainty (standar deviation) added to 
the estimates at each time step. The default value is: \code{GAMMA = 0.03}.}

\item{a}{A Player object}
}
\value{
Player object
}
\description{
Player class
}
\examples{
a1 = Player(prior = Gaussian(0,6), beta = 1, gamma = 0.03); 
a2 = Player()
a1@gamma == a2@gamma 
N = performance(a1) 
N@mu == a1@prior@mu
N@sigma == sqrt(a1@prior@sigma^2 + a1@beta^2)

}
