% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_second_down_recon}
\alias{mpl_second_down_recon}
\title{Performs the second nodal reconstructions for characters with
inapplicability.}
\usage{
mpl_second_down_recon(node_id, left_id, right_id, morphyobj)
}
\arguments{
\item{node_id}{The index of the node being reconstructed.}

\item{left_id}{The index of the left descendant.}

\item{right_id}{The index of the right descendant.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
The integral parsimony length (right now)
}
\description{
Updates the nodal sets that had ambiguous unions with the
inapplicable state and calculates steps involving applicable states after
the update.
Because this function needs to be fairly high-performance, it does not do much
checking for parameter validity, thus unsafe usage of this function might not
be caught. It is up to calling functions to ensure that the appropriate
parameters have been set before use.
}
\seealso{
Other Morphy API functions: 
\code{\link{GapHandler}()},
\code{\link{MorphyErrorCheck}()},
\code{\link{MorphyWeights}()},
\code{\link{PhyDat2Morphy}()},
\code{\link{SingleCharMorphy}()},
\code{\link{UnloadMorphy}()},
\code{\link{is.morphyPtr}()},
\code{\link{mpl_apply_tipdata}()},
\code{\link{mpl_attach_rawdata}()},
\code{\link{mpl_attach_symbols}()},
\code{\link{mpl_delete_Morphy}()},
\code{\link{mpl_first_down_recon}()},
\code{\link{mpl_first_up_recon}()},
\code{\link{mpl_get_charac_weight}()},
\code{\link{mpl_get_gaphandl}()},
\code{\link{mpl_get_num_charac}()},
\code{\link{mpl_get_num_internal_nodes}()},
\code{\link{mpl_get_numtaxa}()},
\code{\link{mpl_get_symbols}()},
\code{\link{mpl_init_Morphy}()},
\code{\link{mpl_new_Morphy}()},
\code{\link{mpl_second_up_recon}()},
\code{\link{mpl_set_charac_weight}()},
\code{\link{mpl_set_num_internal_nodes}()},
\code{\link{mpl_set_parsim_t}()},
\code{\link{mpl_translate_error}()},
\code{\link{mpl_update_lower_root}()},
\code{\link{mpl_update_tip}()},
\code{\link{summary.morphyPtr}()}
}
\author{
Thomas Guillerme
}
\concept{Morphy API functions}
\keyword{internal}
