% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-refactor-data.R
\name{process_hauls}
\alias{process_hauls}
\title{Process fishing haul data from PRODUCE sitrapesca files}
\usage{
process_hauls(data_hauls, correct_coordinates = TRUE, verbose = FALSE)
}
\arguments{
\item{data_hauls}{Data frame with raw haul data.}

\item{correct_coordinates}{Logical. Correct coordinate errors during conversion.}

\item{verbose}{Logical. Print column mapping information.}
}
\value{
Data frame with 16 standardized columns including fishing trip code,
haul number, dates, coordinates, species, and catch data.
}
\description{
Processes fishing haul data from PRODUCE logbooks. Automatically detects
required columns and creates standardized output with coordinates converted
to decimal degrees.
}
\examples{
processed_hauls <- process_hauls(data_hauls = calas_bitacora)
processed_hauls <- process_hauls(data_hauls = calas_bitacora, verbose = TRUE)

}
