% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDF.R
\name{mergeDF}
\alias{mergeDF}
\title{An Alternative Merge Operation}
\usage{
mergeDF(
  x,
  table,
  by = character(),
  by.x = character(),
  by.table = character(),
  ...
)
}
\arguments{
\item{x}{\link[base]{data.frame}, on which new columns will be added.
All rows of \code{x} will be retained in the returned object, \emph{in their original order}.}

\item{table}{\link[base]{data.frame}, columns of which will be added to \code{x}.
Not all rows of \code{table} will be included in the returned object}

\item{by}{\link[base]{character} scalar or \link[base]{vector}}

\item{by.x, by.table}{\link[base]{character} scalar or \link[base]{vector}}

\item{...}{additional parameters of \link{matchDF}}
}
\value{
Function \link{mergeDF} returns a \link[base]{data.frame}.
}
\description{
..
}
\note{
We avoid \link[base]{merge.data.frame} as much as possible,
because it's slow and
even \code{sort = FALSE} may not completely retain the original order of input \code{x}.
}
\examples{
# examples inspired by ?merge.data.frame 

(authors = data.frame(
 surname = c('Tukey', 'Venables', 'Tierney', 'Ripley', 'McNeil'),
 nationality = c('US', 'Australia', 'US', 'UK', 'Australia'),
 deceased = c('yes', rep('no', 4))))
(books = data.frame(
 name = c('Tukey', 'Venables', 'Tierney', 'Ripley', 
  'Ripley', 'McNeil', 'R Core', 'Diggle'),
 title = c(
  'Exploratory Data Analysis',
  'Modern Applied Statistics',
  'LISP-STAT', 'Spatial Statistics', 'Stochastic Simulation',
  'Interactive Data Analysis', 'An Introduction to R',
  'Analysis of Longitudinal Data'),
 other.author = c(
  NA, 'Ripley', NA, NA, NA, NA, 'Venables & Smith',
  'Heagerty & Liang & Scott Zeger')))

(m = mergeDF(books, authors, by.x = 'name', by.table = 'surname'))
attr(m, 'nomatch')

}
