% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{calculate_pred_metrics_cv}
\alias{calculate_pred_metrics_cv}
\title{Calculate Prediction Metrics}
\usage{
calculate_pred_metrics_cv(predictions, actual)
}
\arguments{
\item{predictions}{A numeric vector of model predictions.}

\item{actual}{A numeric vector of the true outcome values.}
}
\value{
A list containing the following numeric elements:
\itemize{
\item \code{RMSE}: Root Mean Squared Error.
\item \code{R_squared}: R-squared (Coefficient of Determination).
}
}
\description{
Computes Root Mean Squared Error (RMSE) and R-squared.
}
\details{
The function is robust to missing values (\code{NA}) within the input vectors, as they
are removed prior to calculation (\code{na.rm = TRUE}). It also handles multiple
edge cases, returning \code{NA} for both metrics if inputs are \code{NULL}, empty, contain only
\code{NA}s, or are of unequal length. If the variance of \code{actual} values is
near zero, \code{R_squared} is handled safely.
}
\note{
Inputs are numeric vectors of equal length. NAs are removed via
\code{na.rm = TRUE}; if inputs are NULL/empty/all-NA/length-mismatch, both
metrics are returned as \code{NA_real_}.
}
\examples{
# --- Example for an internal function ---
# Example predicted values from a model
predicted_values <- c(2.5, 3.8, 6.1, 7.9)

# The corresponding actual, true values
actual_values <- c(2.2, 4.1, 5.9, 8.3)

# Calculate the prediction metrics
metrics <- calculate_pred_metrics_cv(
  predictions = predicted_values,
  actual = actual_values
)

print(metrics)
#> Expected output:
#> $RMSE
#> [1] 0.3082207
#> $R_squared
#> [1] 0.981269
}
