% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{pDisHoeffInd}
\alias{pDisHoeffInd}
\alias{dDisHoeffInd}
\alias{rDisHoeffInd}
\alias{qDisHoeffInd}
\title{Null asymptotic distribution of t* in the discrete case}
\usage{
pDisHoeffInd(x, probs1, probs2, lower.tail = TRUE, error = 10^-5)

dDisHoeffInd(x, probs1, probs2, error = 10^-3)

rDisHoeffInd(n, probs1, probs2)

qDisHoeffInd(p, probs1, probs2, error = 10^-4)
}
\arguments{
\item{x}{the value (or vector of values) at which to evaluate the function.}

\item{probs1}{a vector of probabilities corresponding to the (ordered)
support of X. That is if your first random variable has support
\eqn{u_1,...,u_n} then the ith entry of probs should be
\eqn{P(X = u_i)}.}

\item{probs2}{just as probs1 but for the second random variable Y.}

\item{lower.tail}{a logical value, if TRUE (default), probabilities are
\eqn{P(X\leq x)} otherwise \eqn{P(X>x)}.}

\item{error}{a tolerated error in the result. This should be considered as a
guide rather than an exact upper bound to the amount of error.}

\item{n}{the number of observations to return.}

\item{p}{the probability (or vector of probabilities) for which to get the
quantile.}
}
\value{
dDisHoeffInd gives the density, pDisHoeffInd gives the distribution
        function, qDisHoeffInd gives the quantile function, and
        rDisHoeffInd generates random samples.
}
\description{
Density, distribution function, quantile function and random generation for
the asymptotic null distribution of t* in the discrete case. That is, in the
case that t* is generated from a sample of jointly discrete independent
random variables X and Y.
}
