% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_selection.R
\name{candidate_selection}
\alias{candidate_selection}
\title{Selects the candidates of the tail}
\usage{
candidate_selection(sample, pc_max, pc_min)
}
\arguments{
\item{sample}{A numeric vector.}

\item{pc_max}{A number between pm_max and 1  indicating the threshold of maximum sensitive points to consider.}

\item{pc_min}{A number between pm_min and 1  indicating the threshold of minimum sensitive points to consider.}
}
\value{
A vector of indices corresponding to the detected sensitive points.
}
\description{
This function selects the candidates of the tail that can be inconsistent to the ID hypothesis
}
\examples{
candidate_selection(rnorm(1000), 0.99, 0.99)
candidate_selection(c(rnorm(10^3,10,1),rnorm(10,20,3)), 0.9, 0.9)
}
