% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myersonvalue.R
\name{myersonvalue}
\alias{myersonvalue}
\title{Myerson value}
\usage{
myersonvalue(v, binary = FALSE, communications, game = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{communications}{An undirected communications network, as a list of vectors (their order being irrelevant), each containing two different players (their order being irrelevant). If two players are able to communicate with each other, a bidimensional vector containing them should be present in the list; otherwise, the vector should be absent. When \code{communications} is not specified, it is assumed that all players can communicate with each other.}

\item{game}{A logical value. By default, \code{game=FALSE}. If set to \code{TRUE}, the game with restricted communication is also returned.}
}
\value{
The corresponding Myerson value, as a vector.
}
\description{
Given a game and a communications network, this function computes the Myerson value.
}
\details{
Let \eqn{v\in G^N}. Assuming that communication between players is necessary for their cooperation,
the game with restricted communication, \eqn{v^{A}}, is defined by
\eqn{v^{A}(S)=v(S)} if the players of S can communicate and \eqn{v^{A}(S)=0} otherwise, for each \eqn{S\in 2^N}.

The Myerson value is the Shapley value of the game \eqn{v^{A}}.
}
\examples{
v <- c(0,0,0,0,30,30,40,40,50,50,60,70,80,90,100)
communications <- list(c(1,2), c(1,3), c(1,4))
myersonvalue(v, binary=FALSE, communications)
}
\references{
Myerson, R. B. (1977). Graphs and cooperation in games. \emph{Mathematics of Operations Research}, 2(3), 225-229.
}
\seealso{
\link{shapleyvalue}
}
