% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancedfamilycheck.R
\name{balancedfamilycheck}
\alias{balancedfamilycheck}
\title{Balanced family check}
\usage{
balancedfamilycheck(Fam, n = NULL, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{Fam}{A vector containing the binary order positions of a family of coalitions.}

\item{n}{The number of players in the set of players from which \code{Fam} is taken. When not specified, \code{n} is assumed to be the the number of players present in \code{Fam}.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
This function returns three outputs: \code{check}, \code{minimal} and \code{delta}.
If \code{Fam} is not a balanced family: \code{check=FALSE} and both \code{minimal} and \code{delta} are \code{NULL}.
If \code{Fam} is a balanced family: \code{check=TRUE}, \code{minimal=TRUE} if \code{Fam} is minimal (\code{minimal=FALSE} otherwise), and \code{delta} returns an associated weight family.
}
\description{
This function checks if the given family is balanced.
}
\details{
A family \eqn{F} of non-empty coalitions of a set of players \eqn{N}
is balanced if there exists a weight family \eqn{\delta^{F} = \{ \delta^{F}_{S} \}_{S \in F}} such that
\eqn{\delta^{F}_{S} > 0} for each \eqn{S \in F} and \eqn{\sum_{S \in F} \delta^{F}_{S} e^{S} = e^{N}},
being \eqn{e^{S}} the characteristic vector of \eqn{S}, that is, the vector \eqn{(e_{i}^{S})_{i \in N}}
in which \eqn{e_{i}^{S}=1} if \eqn{i \in S} and \eqn{e_{i}^{S}=0} if \eqn{i \notin S}).

A balanced family \eqn{F} is said to be minimal if there does not exist
a balanced family \eqn{F'} such that \eqn{F' \subsetneq F}.
}
\examples{
balancedfamilycheck(c(3,6,13,8)) # balanced and minimal
balancedfamilycheck(c(3,5,9,4,8,14)) # balanced but not minimal
balancedfamilycheck(c(1,2,4,12,13)) # not balanced
}
\references{
Maschler, M., Solan, E., & Zamir, S. (2013). \emph{Game Theory}. Cambridge University Press.
}
\seealso{
\link{balancedcheck}, \link{kohlbergcriterion}, \link{totallybalancedcheck}
}
