% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTS-package.R
\docType{data}
\name{Epoxy}
\alias{Epoxy}
\title{Dataset obtained from creep tests of an epoxy based composite by using
Dynamic Mechanical Thermal Analysis (DMTA)}
\format{
This data frame is composed of the following columns: 
\describe{
\item{Log10_time}{It accounts for 39 different times from 2 s to
3599 s, in logarithmic scale for each one of the 7 studied temperatures
(overall 273 observations).} 
\item{Log10_Compliance}{It accounts for
39 different values for the compliance, J (MPa-1), for each one of the 7
studied temperatures, in base-ten logarithmic scale. }
\item{Temperature}{It is the variable that shows the temperature at
which the measurements of compliance are experimentally obtained, namely 30,
40, 50, 60, 70, 80, and 90 Celsius degrees.} }
}
\source{
Janeiro-Arocas, J., Tarrío-Saavedra, J., López-Beceiro, J., Naya, S.,
López-Canosa, A., Heredia-García, N., and Artiaga, R. (2016). Creep
analysis of silicone for podiatry applications. Journal of the Mechanical
Behavior of Biomedical Materials, 63, 456-469. DOI
10.1016/j.jmbbm.2016.07.014.

Naya, S., Meneses A,. Tarrio-Saavedra, J,. Artiaga R., Lopez-Beceiro, J. and
Gracia-Fernandez C. (2013) New method for estimating shift factors in
time-temperatura superposition models. Journal of Thermal Analysis and
Calorimetry. ISSN 1388-6150. DOI 10.1007/s10973-013-3193-1.
}
\description{
Epoxy is a dataset composed of 273 rows and 3 columns that describes the
performance of an epoxy resin based composite in a creep type test. This
type of laboratory experimental procedure is defined by the application of a
constant stress, \eqn{\sigma}, and the measuring of the strain, \eqn{\varepsilon (t)}, or compliance, \eqn{J(t)= \varepsilon (t) / \sigma}  (in the present case) as the response variable. The experimental tests are made by Dynamic Mechanical Thermal Analysis (DMTA) technique, using a 3 point bending configuration with the following features: Clamp, 3-Point Bending; Geometry, Rectangular; Size: length of 20 mm, width of 5.55 mm, and thickness of about 0.85 mm.
}
\details{
The dataset includes the measurements of the compliance property depending
on the time and corresponding to different specimens of an epoxy resin based
composite. All the observations were obtained by the application of the DMTA
experimental technique. The application of the TTS principle to creep tests
is becoming more and more common. Creep test provides information about the
deformation of a material subjected to a constant load. This test is in
accordance with many real applications such as the performance of shoe
insoles, structural materials, asphalt, etc. In this framework, TTS provides
the degree of the deformation of the material at an extended range of times,
when this material is subjected to a constant load. Therefore, TTS is
becoming increasingly useful in studies of material degradation and lifetime
estimation. The use of the TTS principle with creep tests usually provides
smoother master curves since each curve is usually defined by a larger
number of experimental observations than, for example, modulus curves as a
function of frequency.
}
\examples{

data(Epoxy)

}
\keyword{datasets}
