% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postInclusionProb.R
\name{postInclusionProb}
\alias{postInclusionProb}
\title{Posterior inclusion probability (PIP)}
\usage{
postInclusionProb(object)
}
\arguments{
\item{object}{An object of class \code{PMP}}
}
\value{
an named vector with all PIPs
}
\description{
This function computes the PIPs of all potential predictors
}
\examples{
# extract the data:
data("VAP_data")

# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here we define time as a spline with 3 knots

# computation of the posterior model probabilities:
test <- PMP(fullModel = FULL, data = VAP_data,
            discreteSurv = TRUE, maxit = 150)
class(test)

#computation of the posterior inclusion probabilities:
postInclusionProb(test)

}
\author{
Rachel Heyard
}
