\name{Phenotypic_Path_app}
\alias{Phenotypic_Path_app}
\title{Phenotypic Path}
\description{
\code{Phenotypic_Path_app()} function opens an interactive and user-friendly Shiny application that enables users to perform phenotypic path analysis.
}
\usage{
Phenotypic_Path_app()
}
\details{
The application is designed to perform phenotypic path analysis using experimental data.

Users can upload an Excel file (.xlsx or .xls) containing observations for several genotypes and traits. After uploading the file users should click the "Analyze" button.

The output includes:
\itemize{
  \item A table displaying direct and indirect effects of independent traits on the dependent trait.
  \item Residual effect value.

}

\strong{The result table can be downloaded in CSV format.}

\strong{Note:} The analysis is based on the Randomized Block Design (RBD).
}
\section{Data Format}{
The uploaded Excel file should be formatted as follows:

\itemize{
  \item First column: Replication
  \item Second column: Genotypes
  \item Subsequent columns: Trait values (e.g., DBH, PH, FW, SW, KW, OC)
  \item \strong{Important:} The last column must be the dependent trait  for path analysis. For example, if OC (Oil Content) is the dependent trait , it must be in the last column.
}

Trait names should be concise. Example:
\itemize{
  \item DBH : Diameter at Breast Height
  \item PH : Plant Height
  \item FW : Fruit Weight
  \item SW : Seed Weight
  \item KW : Kernel Weight
  \item OC : Oil Content
}

\strong{Note:} The uploaded file name should not contain spaces. For example, use \code{Sample_Data.xlsx} instead of \code{Sample Data.xlsx}.

An example Excel file is available for download using the \code{Download Example Data} button within the application.

The example dataset includes:
\itemize{
  \item 170 genotypes
  \item 3 replications for each genotype
  \item 6 traits: 5 independent traits (DBH, PH, FW, SW, KW) and 1 dependent trait: OC
}
}
\value{
Opens a user-friendly interactive Shiny application for performing phenotypic path analysis.
}

\references{
Singh, R. K., & Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis.\cr
Dewey, D. R., & Lu, K. H. (1959). A Correlation and Path-Coefficient Analysis of Components of Crested Wheatgrass Seed Production.Agronomy Journal, 51(9), 515-518.

}
\examples{
if(interactive()) Phenotypic_Path_app()
}
