% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{describe_survey}
\alias{describe_survey}
\title{Generate comprehensive survey description}
\usage{
describe_survey(data, weight_col = NULL)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{weight_col}{Character string specifying column name containing weights (optional)}
}
\value{
A list containing descriptive statistics
}
\description{
This function provides a comprehensive description of survey data including
sample size, variable types, missing value patterns, and basic statistics.
Can incorporate survey weights if provided.
}
\examples{
data <- data.frame(
  age = c(25, 30, 35),
  gender = c("M", "F", "M"),
  weight = c(1.2, 0.8, 1.0)
)
desc <- describe_survey(data)
desc_weighted <- describe_survey(data, "weight")
}
